/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.shells.construct;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JOptionPane;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.DebugShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class DebugActionListener
implements ActionListener {
    private GrammarEditorShellController controller;

    public DebugActionListener(GrammarEditorShellController controller) {
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GrammarEditorShell grammarShell = this.controller.editor;
        Dimension preferedDimension = grammarShell.getPreferredSize();
        Point locationPoint = grammarShell.getLocation();
        try {
            grammarShell.setIcon(false);
        }
        catch (PropertyVetoException e1) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
        }
        if (grammarShell.getSize().height != preferedDimension.height || grammarShell.getSize().width != preferedDimension.width) {
            grammarShell.setSize(preferedDimension);
        }
        if (locationPoint.x != 100 || locationPoint.y != 100) {
            grammarShell.setLocation(100, 100);
        }
        if (grammarShell.formGramStruct != null) {
            grammarShell.formGramStruct.dispose();
            grammarShell.formGramStruct = null;
        }
        if (this.controller.debugShell != null) {
            try {
                this.controller.debugShell.setSelected(true);
            }
            catch (PropertyVetoException e1) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Error while setting unappropriate property!", "NooJ Error!", 0);
            }
        } else {
            DebugShell debugShell = new DebugShell(this.controller);
            Launcher.getDesktopPane().add(debugShell);
            debugShell.setVisible(true);
            this.controller.debugShell = debugShell;
        }
    }
}

